/**
 * 
 */
package com.ejie.ab18a.recogidaInformacion;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;

import com.ejie.ab18a.consulta.Ab18aRealizarProcesoBD;
import com.ejie.ab18a.log.Ab18aLog;
import com.ejie.ab18a.modelo.Ab18aRespuestaWS;
import com.ejie.ab18a.utilidades.Ab18aConexionOracle;
import com.ejie.ab18a.utilidades.Ab18aConstantes;
import com.ejie.ab18a.utilidades.Ab18aException;
import com.ejie.ab18a.utilidades.Ab18aWSUtils;

import eu.europa.ec.publications.esentool.rest.client.EsentoolRestClient;
import eu.europa.ec.publications.esentool.rest.client.NoticeInformation;
import eu.europa.ec.publications.esentool.rest.client.EsentoolRestClient.EsentoolRestClientBuilder;
import eu.europa.ec.publications.esentool.rest.client.RestClientException;

public class Ab18aRecogidaInformacionBoletines {

	private Ab18aRecogidaInformacionBoletines() {
		
	}
	
	public static void main(String[] args) throws Ab18aException {
		Connection connectionOracle = null;
		Ab18aLog.configure("Ab18aRecogidaInformacionBoletines", 1);
		
		String nombre_metodo = "recogidaInformacionBoletines";
		
		try {

			if (connectionOracle == null) {
				// Abrimos la conexion
				connectionOracle = Ab18aConexionOracle.conectar(args);
			}

			Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Conexión abierta", 1);
			
			// Obtenemos las peticiones a consultar
			List<Ab18aRespuestaWS> lstRespuesta = Ab18aRealizarProcesoBD.getInstance().obtenerPeticionesRecogida(connectionOracle);
			
			Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Se han recuperado " + lstRespuesta.size() + " peticiones", 1);
			// Comprobamos si hay alguna peticion en la lista
			if (lstRespuesta != null && !lstRespuesta.isEmpty()) {
				Integer estadoActual = 0;
				// Instanciamos el cliente de eSentool
				Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Instanciando cliente de eSentool", 1);
				EsentoolRestClient client = new EsentoolRestClientBuilder(Ab18aConstantes.URL_ERPI_PRODUCCION_TEST, Ab18aConstantes.ESENTOOL_USER, Ab18aConstantes.ESENTOOL_PW).build();
				//EsentoolRestClient client = new EsentoolRestClientBuilder("https://esentool.ted.europa.eu/api/production","TED39","KONTRATAZIOa1!").build();

				if (client != null) {
					Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Cliente de eSentool instanciado correctamente", 1);
					// Iteramos por cada petición
					for (Ab18aRespuestaWS respuesta : lstRespuesta) {
						Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Procesando la peticion " + respuesta.getT01IdPeticionEnvio(), 1);
						try {
							// Obtenemos el estado actual de la peticion 
							estadoActual = Ab18aRealizarProcesoBD.getInstance().obtenerEstadoPeticion(connectionOracle,respuesta.getT01IdPeticionEnvio().intValue());
							// Obtenemos la información del anuncio
							NoticeInformation noticeInfo = client.getNoticeInformation(respuesta.getT13IdEnvioWs());
							
							// Comprobamos el anuncio ha devuelto información
							if (noticeInfo != null) {
								Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Anuncio recibido", 1);
								// Actualizamos la tabla AB18A13T00 con la información
								Ab18aRealizarProcesoBD.getInstance().actualizarEnvioBoletin(connectionOracle, noticeInfo, respuesta.getT01IdPeticionEnvio().intValue());
								Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Boletin actualizado", 1);
								Map<String, Object> mapaAtributos = new HashMap<String, Object>();
								mapaAtributos.put("idPeticion", respuesta.getT01IdPeticionEnvio().intValue());
								mapaAtributos.put("numIntentos", null);
								// Comprobamos el estado que ha devuelto la llamada
								if (noticeInfo.getStatus().name().equals(Ab18aConstantes.IN_PROGRESS)) {
									mapaAtributos.put("idEstado", Ab18aConstantes.PUBLICANDO);
									Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "El anuncio está publicando " + mapaAtributos, 1);
								} else if (noticeInfo.getStatus().name().equals(Ab18aConstantes.NOT_PUBLISHED)) {
									mapaAtributos.put("idEstado", Ab18aConstantes.ELIMINADO);
									mapaAtributos.put("numIntentos", 5);
									mapaAtributos.put("idError", Ab18aRealizarProcesoBD.getInstance().obtenerIdErrorEsentool(connectionOracle, noticeInfo.getReasonCode()));
									Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "El anuncio está eliminado " + mapaAtributos, 1);
								} else if (noticeInfo.getStatus().name().equals(Ab18aConstantes.PUBLISHED)) {
									// En caso de que esté publicado
									mapaAtributos.put("idEstado", Ab18aConstantes.PUBLICADO);
									Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "El anuncio está publicado " + mapaAtributos, 1);
									if (noticeInfo.getPublicationInfo() != null) {
										// Insertamos Datos publicación
										Ab18aRealizarProcesoBD.getInstance().insertarDatosPublicacion(connectionOracle, noticeInfo.getPublicationInfo(), respuesta.getT01IdPeticionEnvio().intValue());
										Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Datos de publicacion insertados " + noticeInfo.getSubmissionId(), 1);
										if (noticeInfo.getPublicationInfo().getTedLinks() != null && !noticeInfo.getPublicationInfo().getTedLinks().isEmpty()) {
											//Insertar Ted Links
											for (String link : noticeInfo.getPublicationInfo().getTedLinks().values()) {
												Ab18aRealizarProcesoBD.getInstance().insertarTedLinks(connectionOracle, link, respuesta.getT01IdPeticionEnvio().intValue());
												Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Link insertado: " + link, 1);
											}
										}
									}
								} else if (noticeInfo.getStatus().name().equals(Ab18aConstantes.WAITING_FOR_INFORMATION)){
									mapaAtributos.put("idEstado", Ab18aConstantes.ESPERANDO_INFORMACION);
									Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "El anuncio está esperando más información " + mapaAtributos, 1);
								} else if (noticeInfo.getStatus().name().equals(Ab18aConstantes.RECEIVED)){
									mapaAtributos.put("idEstado", Ab18aConstantes.PENDIENTE_PUBLICAR);
									Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "El anuncio está pendiente de publicar " + mapaAtributos, 1);
								} else if (noticeInfo.getStatus().name().equals(Ab18aConstantes.RECEPTION_ERROR)){
									mapaAtributos.put("idEstado", Ab18aConstantes.RECHAZADA);
									mapaAtributos.put("numIntentos", 5);
									mapaAtributos.put("idError", Ab18aRealizarProcesoBD.getInstance().obtenerIdErrorEsentool(connectionOracle, noticeInfo.getReasonCode()));
									Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "El anuncio es erróneo " + mapaAtributos, 1);
								}
								// Actualizamos la peticion
								Ab18aRealizarProcesoBD.getInstance().actualizarPeticionEnvio(connectionOracle, mapaAtributos);
								Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Petición actualizada" + mapaAtributos, 1);
								// Elminamos validaciones antiguas
								Ab18aRealizarProcesoBD.getInstance().eliminarValidaciones(connectionOracle, respuesta.getT01IdPeticionEnvio().intValue());
								Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Validaciones antiguas eliminadas", 1);
								// Almacenamos las nuevas validaciones
								Ab18aRealizarProcesoBD.getInstance().almacenarValidaciones(connectionOracle, noticeInfo, respuesta.getT01IdPeticionEnvio().intValue());
								Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Validaciones nuevas insertadas", 1);
								
								// Commit
								Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Antes del commit", 1);
								Ab18aConexionOracle.commit(connectionOracle);
								Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Commit realizado", 1);
								
								// Comprobamos que haya cambiado el estado del anuncio 
								if (estadoActual.compareTo((Integer )mapaAtributos.get("idEstado")) != 0 ) {
									// Publicamos el evento en la cola JMS
									enviarServicioEvento(respuesta.getT01IdPeticionEnvio().intValue());
									Ab18aLog.debug(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Evento publicado" , 1);
								}
							}
						} catch (RestClientException rce) {
							Ab18aLog.error(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Entra por RestClientException " + rce , 1);
							Map<String, Object> mapaAtributos = new HashMap<String, Object>();
							// Comprobamos que error es
							if (rce.getError() != null) {
								mapaAtributos.put("descError", rce.getError().getMessage());
								Integer status = rce.getError().getStatus();
								Integer numIntentos = 0;
								// Si es un 400 o 404 ponemos el número de
								// reintentos
								// directamente en 5
								if (status.compareTo(Ab18aConstantes.STATUS_400) == 0) {
									numIntentos = 5;
									mapaAtributos.put("idEstado", Ab18aConstantes.ERRONEO);
								} else if(status.compareTo(Ab18aConstantes.STATUS_404) == 0) {
									mapaAtributos.put("idEstado", Ab18aConstantes.ANUNCIO_NO_ENCONTRADO);
									numIntentos++;
								} else {
									mapaAtributos.put("idEstado", Ab18aConstantes.ERRONEO);
									numIntentos++;
								}
								mapaAtributos.put("numIntentos", numIntentos);
								mapaAtributos.put("idPeticion", respuesta.getT01IdPeticionEnvio().intValue());
								
								// Actualizamos la peticion
								Ab18aRealizarProcesoBD.getInstance().actualizarPeticionEnvio(connectionOracle, mapaAtributos);
								try {
									enviarServicioEvento(respuesta.getT01IdPeticionEnvio().intValue());
									// Commit
									Ab18aConexionOracle.commit(connectionOracle);
								} catch (SOAPException se) {
									Ab18aLog.error(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Error al publicar el evento con la información del anuncio " + respuesta.getT13IdEnvioWs() + " de eSentool: " + se, 1);
									Ab18aConexionOracle.rollback(connectionOracle);
								}
							}
						} catch (SOAPException se) {
							Ab18aLog.error(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Error al publicar el evento con la información del anuncio " + respuesta.getT13IdEnvioWs() + " de eSentool: " + se, 1);
							Ab18aConexionOracle.rollback(connectionOracle);
						} catch (Exception e) {
							// TODO: Comprobar retorno servicio ERPI y actualizar peticion
							Ab18aLog.error(Ab18aRecogidaInformacionBoletines.class.getName(), nombre_metodo, "Error al recoger la información del anuncio " + respuesta.getT13IdEnvioWs() + " de eSentool: " + e, 1);
							Ab18aConexionOracle.rollback(connectionOracle);
						}
						
					}
				}
			}
			
		} catch (Exception e) {
			Ab18aLog.error(e.getClass().getName(), nombre_metodo, "Error al recuperar las peticiones de BBDD: " + e, 1);
		} finally {
			Ab18aConexionOracle.desconectar(connectionOracle);
		}
	}
	
	/**
	 * Metodo que llama al web service de enviar el evento
	 * @throws Exception 
	 * @throws SOAPFaultException 
	 */
	private static void enviarServicioEvento(Integer idPeticionEnvio) throws SOAPFaultException, Exception{
		String resultado="";
		try{
			String targetNameSpace = "http://com.ejie.ab18a.webservice";
	        String method = Ab18aConstantes.SERVICIO_ENVIAR_EVENTO_NOMBRE_METODO;
	        String url = Ab18aConstantes.URL_SERVICIO_INTEGRACION;          				
	        String[] params = {"idPeticionEnvio"};
	        String[] values = {String.valueOf(idPeticionEnvio)};
	          
	        resultado = Ab18aWSUtils.llamarWS(targetNameSpace, url, method,params,values);
	        resultado = Ab18aConstantes.CTE_TRUE;
	           
	  
	    } catch (SOAPException se) {
	    	 resultado = Ab18aConstantes.CTE_FALSE;
	          throw se;
	    } catch(Exception ex){
	    	  resultado = Ab18aConstantes.CTE_FALSE;
	          throw ex;
	    } 
	}
}